/*
 * Decompiled with CFR 0.152.
 */
package com.finallion.graveyard.events;

import com.finallion.graveyard.config.GraveyardConfig;
import com.finallion.graveyard.init.TGBiomes;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.potion.Effects;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="graveyard", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class BiomeEvents {
    private static double fogDensity;
    private static final ResourceLocation HAUNTED_FOREST_LOC;
    private static final ResourceLocation HAUNTED_LAKES_LOC;
    private static final ResourceLocation ERODED_FOREST_LOC;

    @SubscribeEvent
    public static void FogDensityEvent(EntityViewRenderEvent.FogDensity event) {
        BlockPos pos = event.getRenderer().func_215316_n().func_216780_d();
        Entity entity = event.getInfo().func_216773_g();
        ResourceLocation location = entity.field_70170_p.func_226691_t_(pos).getRegistryName();
        boolean additionalFog = false;
        if (!(GraveyardConfig.INSTANCE.ENABLE_HAUNTED_FOREST_FOG || GraveyardConfig.INSTANCE.ENABLE_HAUNTED_LAKES_FOG || GraveyardConfig.INSTANCE.ENABLE_ERODED_HAUNTED_FOREST_FOG)) {
            return;
        }
        if (location == null) {
            return;
        }
        if (entity instanceof LivingEntity && ((LivingEntity)entity).func_70644_a(Effects.field_76440_q)) {
            return;
        }
        if (location.equals((Object)HAUNTED_FOREST_LOC) && GraveyardConfig.INSTANCE.ENABLE_HAUNTED_FOREST_FOG) {
            if (pos.func_177956_o() > GraveyardConfig.INSTANCE.HAUNTED_FOREST_FOG_MAXY || pos.func_177956_o() < GraveyardConfig.INSTANCE.HAUNTED_FOREST_FOG_MINY) {
                return;
            }
            fogDensity = GraveyardConfig.INSTANCE.HAUNTED_FOREST_FOG_DENSITY;
        } else if (location.equals((Object)HAUNTED_LAKES_LOC) && GraveyardConfig.INSTANCE.ENABLE_HAUNTED_LAKES_FOG) {
            if (pos.func_177956_o() > GraveyardConfig.INSTANCE.HAUNTED_LAKES_FOG_MAXY || pos.func_177956_o() < GraveyardConfig.INSTANCE.HAUNTED_LAKES_FOG_MINY) {
                return;
            }
            fogDensity = GraveyardConfig.INSTANCE.HAUNTED_LAKES_FOG_DENSITY;
        } else if (location.equals((Object)ERODED_FOREST_LOC) && GraveyardConfig.INSTANCE.ENABLE_ERODED_HAUNTED_FOREST_FOG) {
            if (pos.func_177956_o() > GraveyardConfig.INSTANCE.ERODED_HAUNTED_FOREST_FOG_MAXY || pos.func_177956_o() < GraveyardConfig.INSTANCE.ERODED_HAUNTED_FOREST_FOG_MINY) {
                return;
            }
            fogDensity = GraveyardConfig.INSTANCE.ERODED_HAUNTED_FOREST_FOG_DENSITY;
        } else {
            return;
        }
        event.setDensity((float)fogDensity);
        event.setCanceled(true);
    }

    static {
        HAUNTED_FOREST_LOC = TGBiomes.HAUNTED_FOREST.getRegistryName();
        HAUNTED_LAKES_LOC = TGBiomes.HAUNTED_LAKES.getRegistryName();
        ERODED_FOREST_LOC = TGBiomes.ERODED_HAUNTED_FOREST.getRegistryName();
    }
}

